<?php
/* --------------------------------------------------------------
   FetchedSpecificTrackingCode.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCode;

/**
 * Class FetchedSpecificTrackingCode
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class FetchedSpecificTrackingCode
{
    /**
     * @var TrackingCode
     */
    private $trackingCode;
    
    
    /**
     * FetchedSpecificTrackingCodeEvent constructor.
     *
     * @param TrackingCode $trackingCode
     */
    private function __construct(TrackingCode $trackingCode)
    {
        $this->trackingCode = $trackingCode;
    }
    
    
    /**
     * @param TrackingCode $trackingCode
     *
     * @return FetchedSpecificTrackingCode
     */
    public static function create(TrackingCode $trackingCode): FetchedSpecificTrackingCode
    {
        return new self($trackingCode);
    }
    
    
    /**
     * @return TrackingCode
     */
    public function trackingCode(): TrackingCode
    {
        return $this->trackingCode;
    }
    
    
    /**
     * @param TrackingCode $trackingCode
     */
    public function replaceTrackingCode(TrackingCode $trackingCode): void
    {
        $this->trackingCode = $trackingCode;
    }
}